#ifndef __Collections__
#define __Collections__

/**
 * @file Collections.h
 * @brief Single include for the Exponent Collections namespace
 *
 * @date 23/01/2006
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Collections.h,v 1.4 2007/02/08 21:06:44 paul Exp $
 */
/**
 * @namespace Exponent::Collections
 * @brief Main Collections namespace
 *
 * Contains Templated container classes
 */

#include "TAutomaticPointer.hpp"
#include "TCollection.hpp"
#include "TCountedPointerArray.hpp"
#include "TMatrix.hpp"
#include "TPointerCollection.hpp"
#include "TPointerDeleter.hpp"
#include "CollectionTypedef.h"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Collections;
#endif

#endif	// End of Collections.h